// Generated by CoffeeScript 1.9.1
(function() {
  var Settings, root;

  root = typeof exports !== "undefined" && exports !== null ? exports : window;

  root.Settings = Settings = {
    get: function(key) {
      if (key in localStorage) {
        return JSON.parse(localStorage[key]);
      } else {
        return this.defaults[key];
      }
    },
    set: function(key, value) {
      var jsonValue;
      if (value === this.defaults[key]) {
        return this.clear(key);
      } else {
        jsonValue = JSON.stringify(value);
        localStorage[key] = jsonValue;
        return Sync.set(key, jsonValue);
      }
    },
    clear: function(key) {
      if (this.has(key)) {
        delete localStorage[key];
      }
      return Sync.clear(key);
    },
    has: function(key) {
      return key in localStorage;
    },
    postUpdateHooks: {
      keyMappings: function(value) {
        root.Commands.clearKeyMappingsAndSetDefaults();
        root.Commands.parseCustomKeyMappings(value);
        return root.refreshCompletionKeysAfterMappingSave();
      },
      exclusionRules: function(value) {
        return root.Exclusions.postUpdateHook(value);
      }
    },
    performPostUpdateHook: function(key, value) {
      if (this.postUpdateHooks[key]) {
        return this.postUpdateHooks[key](value);
      }
    },
    defaults: {
      scrollStepSize: 60,
      omniSearchWeight: 0.4,
      smoothScroll: true,
      keyMappings: "# 此处插入您的首选按键映射。",
      linkHintCharacters: "sadfjklewcmpgh",
      linkHintNumbers: "0123456789",
      filterLinkHints: false,
      hideHud: false,
      userDefinedLinkHintCss: "div > .vimiumHintMarker {\n/* linkhint boxes */\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#FFF785),\n  color-stop(100%,#FFC542));\nborder: 1px solid #E3BE23;\n}\n\ndiv > .vimiumHintMarker span {\n/* linkhint text */\ncolor: black;\nfont-weight: bold;\nfont-size: 12px;\n}\n\ndiv > .vimiumHintMarker > .matchingCharacter {\n}",
      exclusionRules: [
        {
          pattern: "http*://mail.google.com/*",
          passKeys: ""
        }
      ],
      previousPatterns: "prev,previous,back,<,\u2190,\xab,\u226a,<<",
      nextPatterns: "next,more,>,\u2192,\xbb,\u226b,>>",
      searchUrl: "https://www.google.com/search?q=",
      searchEngines: ["w: http://www.wikipedia.org/w/index.php?title=Special:Search&search=%s Wikipedia", "", "# 更多示例。", "#", "# (Vimium 内置这些自动完成引擎。)", "#", "# g: http://www.google.com/search?q=%s Google", "# l: http://www.google.com/search?q=%s&btnI 手气不错...", "# y: http://www.youtube.com/results?search_query=%s Youtube", "# b: https://www.bing.com/search?q=%s Bing", "# d: https://duckduckgo.com/?q=%s DuckDuckGo", "# az: http://www.amazon.com/s/?field-keywords=%s Amazon", "#", "# 另一个示例 (不含自动完成的 Vimium).", "#", "# m: https://www.google.com/maps/search/%s Google Maps"].join("\n"),
      newTabUrl: "chrome://newtab",
      grabBackFocus: false,
      settingsVersion: Utils.getCurrentVersion()
    }
  };

  if (Utils.compareVersions("1.42", Settings.get("settingsVersion")) !== -1) {
    Settings.set("scrollStepSize", parseFloat(Settings.get("scrollStepSize")));
  }

  Settings.set("settingsVersion", Utils.getCurrentVersion());

  chrome.storage.local.get("findModeRawQueryList", function(items) {
    var rawQuery;
    if (!(chrome.runtime.lastError || items.findModeRawQueryList)) {
      rawQuery = Settings.get("findModeRawQuery");
      return chrome.storage.local.set({
        findModeRawQueryList: (rawQuery ? [rawQuery] : [])
      });
    }
  });

}).call(this);
